#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <map>
using namespace std;

struct Point_2
{
public:
    double x;
    double y;
    Point_2(double a, double b)
    {
        x = a;
        y = b;
    };
    
    Point_2 operator - (const Point_2& P) const
    {
        return Point_2( x - P.x, y - P.y );
    };
};


/*-------- Mesh Data --------*/
vector<Point_2> VT; //parameterization
map< pair<int, int>, int > E; //edge data and corresponding id
vector< vector< pair<int, int> > > E_UV; //uv_id for each edge


/*
 edge i->j == edge j->i
 */
pair<int, int> get_id(int i, int j)
{
    if(i > j)
        swap(i, j);
    return make_pair(i, j);
}

void add_edge(int i, int j, int uv_i, int uv_j)
{
    //If edge exists?
    if(i > j)
    {
        swap(i, j);
        swap(uv_i, uv_j);
    }
    pair<int, int> e = make_pair( i, j );
    pair<int, int> uv = make_pair(uv_i, uv_j);

    map< pair<int, int>, int >::iterator it = E.find(e);
    if( E.end() != it )
        E_UV[it->second].push_back( uv );
    else //new edge
    {
        E[e] = E_UV.size();
        
        vector< pair<int, int> > uv_data;
        uv_data.push_back( uv );
        E_UV.push_back( uv_data );
    }
}

void read_obj(char* filename)
{
    
    FILE *ifv = fopen(filename, "rb"); //toUtf8
    char c;
    double px, py, pz;
    int a1, a2, a3, a4, a5, a6;
    char str[500];
    
    int num_v, num_vt, num_vn, num_f;
    bool contains_normals = false;
    
    while(EOF != fscanf(ifv, "%c", &c))
    {
        if('#' == c)
        {
            while('\n' != c)
                fscanf(ifv, "%c", &c);
        }
        else if('v' == c)
        {
            //v, vt, vn
            fscanf(ifv, "%c", &c);
            if(' ' == c)
                fscanf(ifv, "%lf %lf %lf\n", &px, &py, &pz);
            else if('t' == c)
            {
                fscanf(ifv, " %lf %lf\n", &px, &py);
                Point_2 p = Point_2(px, py);
                VT.push_back(p);
            }
            else if('n' == c)
            {
                fscanf(ifv, " %lf %lf %lf\n", &px, &py, &pz);
                contains_normals = true;
            }
            else
            {
                while('\n' != c)
                    fscanf(ifv, "%c", &c);
            }
        }
        else if('f' == c)
        {
            std::vector<int> f;
            for(int k=0; k<3; k++)
            {
                if(contains_normals)
                    fscanf(ifv, " %d/%d/%d", &a1, &a2, &a3);
                else
                    fscanf(ifv, " %d/%d", &a1, &a2);
                f.push_back(a1-1);f.push_back(a2-1);
            }
            fscanf(ifv, "\n");
            
            for(int k=0; k<3; k++)
                add_edge( f[2*k], f[2*((k+1)%3)], f[2*k+1], f[2*((k+1)%3)+1] );
        }
        else
        {
            while('\n' != c)
                fscanf(ifv, "%c", &c);
        }
    }
    fclose(ifv);
}

Point_2 rotate(Point_2 P, int r)
{
    Point_2 P_new = Point_2(P.x, P.y);
    if(1 == r)
        P_new = Point_2( -P.y, P.x );
    else if(2 == r)
        P_new = Point_2(-P.x, -P.y);
    else if(3 == r)
        P_new = Point_2( P.y, -P.x );
    
    return P_new;
}

bool check_edge(int i)
{
    Point_2 a1 = VT[ E_UV[i][0].first ];
    Point_2 b1 = VT[ E_UV[i][0].second ];
    Point_2 a2 = VT[ E_UV[i][1].first ];
    Point_2 b2 = VT[ E_UV[i][1].second ];

    Point_2 d1 = b1 - a1;
    Point_2 d2 = b2 - a2;
    for(int j=0; j<4; j++)
    {
        Point_2 d1_new = rotate(d1, j);
        if( d1_new.x == d2.x && d1_new.y == d2.y )
            return false; //perfect match: edge is truly seamless
    }
    return true; //edge is not seamless
}

void check_edges()
{
    int seam_edges = 0;
    int bad_edges = 0;
    for(unsigned int i=0; i<E_UV.size(); i++)
    {
        if(E_UV[i].size()<1 || E_UV[i].size()>2 ) //boundary
        {
            cout << "bad edge? non manifold surface? " << E_UV[i].size() << endl;
            continue;
        }
        if( 1 == E_UV[i].size() ) //boundary
            continue;
        else if( E_UV[i][0].first == E_UV[i][1].first
                && E_UV[i][0].second == E_UV[i][1].second )
            continue; //non-seam edge
        else if(check_edge(i))
            bad_edges++;
        seam_edges++;
    }
    if(0 == bad_edges)
        cout << "No seamlessness issues found." << endl;
    else
        cout << "Seamlessness issues found at " << bad_edges << " out of " << seam_edges << " seam edges!" << endl;
}

int main(int argc, char **argv)
{
    if(2 == argc)
    {
        //Check for bad UV edge
        read_obj( argv[1] );
        check_edges();
    }
    else
        cout << "Please specify an obj file as input" << endl;

	return 0;
}
